//Dustin Soodak


//Behavior 046: simple edge detection
//
//Note: reset several times while connected to serial terminal while on test surface and with sensors
//over edge or white tape. Adjust "TriggerLevel" and the formulas in EdgeSearchFunction()
//according to type (edge or tape) and amplitude of average.
//Also: when button pressed to start driving towards edge, it prints out the last 8 values
//for right & left edge sensors so you can see how they changed the last time it went over
//the edge. If it hasn't gone over the edge since reset, this will be the values in the
//initial sensor averages.
//
#include "MiscHardware.h"
int Speed=150;
//
int TriggerLevel=50;//press reset
char EdgeSearchFunction(void){//simple version of LookForEdge()
  char edge=0;
  //Update running averages of edge sensors
  LookAtEdge();
  //ultra-simple formula to look for edge using global variables set by LookAtEdge()
  if(RightEdgeSensorValue<RightEdgeSensorAverage-TriggerLevel)//make ">Average+TrigLev" if white tape instead of edge
    edge|=0x1;//binary 01
  if(LeftEdgeSensorValue<LeftEdgeSensorAverage-TriggerLevel)//make ">Average+TrigLev" if white tape instead of edge
    edge|=0x2;//binary 10 
  return edge;
}
//
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  //This section lets you know when the robot restarts:
  PlayChirp(1000, 50);
  SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
  PlayChirp(500, 0);   
  //Prints values to determine TriggerLevel
  ResetLookAtEdge();//initialize LookAtEdge() variables
  SwitchMotorsToSerial();
  Serial.print("left: ");Serial.print(LeftEdgeSensorAverage);Serial.print(" (aver ");Serial.print(LeftEdgeSensorValue);Serial.print(") ");
  Serial.print(" Right: ");Serial.print(RightEdgeSensorAverage);Serial.print(" (aver ");Serial.print(RightEdgeSensorValue);Serial.print(")");
  Serial.println();
}
char edge;
int degr;
int i;
void loop(){
  
  SwitchPixelsToButton();
  while(!ButtonPressed());
  //Print last few values in running averages for left & right edge sensor before the last 
  //time it went off the edge.
  SwitchMotorsToSerial();
  i=(EdgeArrayPos+1)%8;
  Serial.println("Left\tRight");
  while(1){ 
    Serial.print(LeftEdgeArray[i]);Serial.print("\t");Serial.println(RightEdgeArray[i]);
    if(i==EdgeArrayPos)
      break;
    else
      i=(i+1)%8;
  }
  Serial.println("Averages:");
  Serial.print(LeftEdgeSensorAverage);Serial.print("\t");Serial.println(RightEdgeSensorAverage);
  while(ButtonPressed());
  delay(500);//wait for user to release button completely and robot to stop vibrating
  SwitchButtonToPixels();
  SetPixelRGB(6,50,50,50);SetPixelRGB(5,50,50,50);RefreshPixels();
  ResetLookAtEdge();//initialize LookAtEdge()
  NavigationBegin();//make sure it is not moving during this step
  ResumeNavigation();  
  SwitchSerialToMotors();
  edge=0;
  while(edge==0){
    //Maintain heading (super simple version...arduino PID functions will work better if properly tuned)
    SimpleGyroNavigation();
    degr=GetDegrees()+GetDegreesToStop();//guestimate which direction it would face after skidding to a halt
    if(degr>5)
      Motors(Speed-50,Speed+50);
    else if(degr<-5)
      Motors(Speed+50,Speed-50);
    else
      Motors(Speed,Speed);
    //Simple edge detection function
    edge=EdgeSearchFunction();
  }//while(edge==0)
  //Back away from edge (side indicated by headlights) then stop
  Motors(-255,-255);  
  if(edge&0x1)
    SetPixelRGB(5,50,0,0);
  else
    SetPixelRGB(5,0,0,0);
  if(edge&0x2)
    SetPixelRGB(6,50,0,0);
  else
    SetPixelRGB(6,0,0,0);
  RefreshPixels();
  delay(200);
  Motors(0,0);
  //
}//end loop()

